/*
 * Decompiled with CFR 0.152.
 */
package mod.traister101.sns.util.handlers;

import java.util.Optional;
import mod.traister101.sns.config.SNSConfig;
import mod.traister101.sns.util.ContainerType;
import net.dries007.tfc.common.blocks.GroundcoverBlock;
import net.dries007.tfc.common.blocks.rock.LooseRockBlock;
import net.dries007.tfc.common.blocks.wood.FallenLeavesBlock;
import net.minecraft.core.BlockPos;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundTakeItemEntityPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.event.entity.player.EntityItemPickupEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemHandlerHelper;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.type.capability.ICuriosItemHandler;

public final class PickupHandler {
    public static void onPickupItem(EntityItemPickupEvent event) {
        if (!((Boolean)SNSConfig.SERVER.doPickup.get()).booleanValue()) {
            return;
        }
        Player player = event.getEntity();
        ItemEntity itemEntity = event.getItem();
        ItemStack stack = itemEntity.m_32055_();
        int startCount = stack.m_41613_();
        ItemStack itemResult = PickupHandler.pickupItemStack(player, stack);
        int pickupCount = startCount - itemResult.m_41613_();
        itemEntity.m_32045_(itemResult);
        if (0 < pickupCount) {
            player.f_36096_.m_38946_();
            ClientboundTakeItemEntityPacket packet = new ClientboundTakeItemEntityPacket(itemEntity.m_19879_(), player.m_19879_(), pickupCount);
            ((ServerPlayer)player).f_8906_.m_9829_((Packet)packet);
        }
        event.setCanceled(itemResult.m_41619_());
    }

    public static void onBlockActivated(PlayerInteractEvent.RightClickBlock event) {
        if (!((Boolean)SNSConfig.SERVER.doPickup.get()).booleanValue()) {
            return;
        }
        BlockPos blockPos = event.getPos();
        Level level = event.getLevel();
        BlockState blockState = level.m_8055_(blockPos);
        Block block = blockState.m_60734_();
        if (!(block instanceof GroundcoverBlock)) {
            return;
        }
        Player player = event.getEntity();
        if (block instanceof LooseRockBlock && player.m_21205_().m_41720_() == block.m_5456_()) {
            return;
        }
        if (block instanceof FallenLeavesBlock) {
            if (player.m_21205_().m_41720_() == block.m_5456_()) {
                return;
            }
            if ((Integer)blockState.m_61143_((Property)FallenLeavesBlock.LAYERS) > 0) {
                return;
            }
        }
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            Block.m_49874_((BlockState)blockState, (ServerLevel)serverLevel, (BlockPos)blockPos, (BlockEntity)level.m_7702_(blockPos), (Entity)player, (ItemStack)ItemStack.f_41583_).forEach(itemStack -> {
                ItemStack itemResult = PickupHandler.pickupItemStack(player, itemStack);
                if (!itemResult.m_41619_()) {
                    ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)itemResult);
                } else {
                    PickupHandler.playPickupSound((Level)serverLevel, player.m_20182_());
                }
                if (itemResult.m_41613_() != itemStack.m_41613_()) {
                    player.f_36096_.m_38946_();
                }
            });
        }
        level.m_7471_(blockPos, false);
        event.setCancellationResult(InteractionResult.SUCCESS);
        event.setCanceled(true);
    }

    private static ItemStack pickupItemStack(Player player, ItemStack itemPickup) {
        Optional optionalCuriosItemHandler;
        ItemStack remainder = itemPickup.m_41777_();
        Inventory playerInventory = player.m_150109_();
        if (PickupHandler.topOffPlayerInventory(playerInventory, remainder)) {
            return ItemStack.f_41583_;
        }
        if (ModList.get().isLoaded("curios") && (optionalCuriosItemHandler = CuriosApi.getCuriosInventory((LivingEntity)player).resolve()).isPresent()) {
            ICuriosItemHandler curiosItemHandler = (ICuriosItemHandler)optionalCuriosItemHandler.get();
            IItemHandlerModifiable equippedCurios = curiosItemHandler.getEquippedCurios();
            for (int slotIndex = 0; slotIndex < equippedCurios.getSlots(); ++slotIndex) {
                Optional<IItemHandler> containerInv;
                ItemStack itemContainer = equippedCurios.getStackInSlot(slotIndex);
                if (!ContainerType.canDoItemPickup(itemContainer) || (containerInv = itemContainer.getCapability(ForgeCapabilities.ITEM_HANDLER).resolve().filter(h -> PickupHandler.isValidForContainer(h, itemPickup))).isEmpty() || (remainder = PickupHandler.insertStack(remainder, containerInv.get())).m_41619_() || ((Boolean)SNSConfig.SERVER.doVoiding.get()).booleanValue() && !ContainerType.canDoItemVoiding(itemContainer) || !PickupHandler.voidedItem(remainder, containerInv.get())) continue;
                return ItemStack.f_41583_;
            }
        }
        for (int slotIndex = 0; slotIndex < playerInventory.m_6643_(); ++slotIndex) {
            Optional<IItemHandler> containerInv;
            ItemStack itemContainer = playerInventory.m_8020_(slotIndex);
            if (!ContainerType.canDoItemPickup(itemContainer) || (containerInv = itemContainer.getCapability(ForgeCapabilities.ITEM_HANDLER).resolve().filter(h -> PickupHandler.isValidForContainer(h, itemPickup))).isEmpty() || (remainder = PickupHandler.insertStack(remainder, containerInv.get())).m_41619_() || ((Boolean)SNSConfig.SERVER.doVoiding.get()).booleanValue() && !ContainerType.canDoItemVoiding(itemContainer) || !PickupHandler.voidedItem(remainder, containerInv.get())) continue;
            return ItemStack.f_41583_;
        }
        return remainder;
    }

    private static ItemStack insertStack(ItemStack fillStack, IItemHandler itemHandler) {
        ItemStack pickupResult = fillStack.m_41777_();
        for (int slotIndex = 0; slotIndex < itemHandler.getSlots(); ++slotIndex) {
            if (itemHandler.getStackInSlot(slotIndex).m_41613_() >= itemHandler.getSlotLimit(slotIndex) || !(pickupResult = itemHandler.insertItem(slotIndex, pickupResult, false)).m_41619_()) continue;
            return ItemStack.f_41583_;
        }
        return pickupResult;
    }

    private static boolean voidedItem(ItemStack itemStack, IItemHandler itemHandler) {
        for (int slotIndex = 0; slotIndex < itemHandler.getSlots(); ++slotIndex) {
            ItemStack slotStack = itemHandler.getStackInSlot(slotIndex);
            if (!ItemStack.m_41656_((ItemStack)slotStack, (ItemStack)itemStack)) continue;
            itemStack.m_41764_(0);
            return true;
        }
        return false;
    }

    private static boolean isValidForContainer(IItemHandler containerInv, ItemStack itemPickup) {
        for (int slotIndex = 0; slotIndex < containerInv.getSlots(); ++slotIndex) {
            if (!containerInv.isItemValid(slotIndex, itemPickup)) continue;
            return true;
        }
        return false;
    }

    private static boolean topOffPlayerInventory(Inventory inventoryPlayer, ItemStack itemStack) {
        for (int i = 0; i < inventoryPlayer.m_6643_(); ++i) {
            ItemStack inventoryStack = inventoryPlayer.m_8020_(i);
            if (inventoryStack.m_41619_() || inventoryStack.m_41613_() >= inventoryStack.m_41741_() || !ItemStack.m_150942_((ItemStack)inventoryStack, (ItemStack)itemStack)) continue;
            int remainingSpace = inventoryStack.m_41741_() - inventoryStack.m_41613_();
            if (remainingSpace >= itemStack.m_41613_()) {
                inventoryStack.m_41769_(itemStack.m_41613_());
                itemStack.m_41764_(0);
                return true;
            }
            inventoryStack.m_41764_(inventoryStack.m_41741_());
            itemStack.m_41774_(remainingSpace);
        }
        return false;
    }

    private static void playPickupSound(Level level, Vec3 pos) {
        RandomSource rand = level.f_46441_;
        level.m_6263_(null, pos.f_82479_, pos.f_82480_, pos.f_82481_, SoundEvents.f_12019_, SoundSource.PLAYERS, 0.2f, ((rand.m_188501_() - rand.m_188501_()) * 0.7f + 1.0f) * 2.0f);
    }
}

